<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Force Reinstall / Update – Free Plugin by DrGlenn</title>
  <meta name="description" content="A tiny utility plugin that makes WordPress think every plugin has an update, so you can quickly reinstall from the Updates screen. Deactivate to clear notices." />
  <link rel="preconnect" href="https://fonts.googleapis.com"/>
  <style>
    :root{
      --fg:#111;
      --muted:#555;
      --bg:#fff;
      --card:#fafafa;
      --border:#e6e6e6;
      --link:#0b5fff;
      --accent:#0b5fff;
      --accent-ink:#fff;
      --code:#0d1117;
      --code-ink:#e6edf3;
      --radius:14px;
      --max:820px;
    }
    *{box-sizing:border-box}
    html,body{margin:0;padding:0;background:var(--bg);color:var(--fg);font:16px/1.6 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,Helvetica,Arial,"Apple Color Emoji","Segoe UI Emoji"}
    a{color:var(--link);text-decoration:underline}
    header,main,footer{width:100%;display:block}
    .wrap{max-width:var(--max);margin:0 auto;padding:28px 22px}
    header .kicker{font-weight:600;color:var(--muted);letter-spacing:.2px}
    h1{font-size: clamp(28px, 4.5vw, 48px);line-height:1.1;margin:6px 0 14px}
    h2{font-size: clamp(20px, 2.8vw, 28px);margin:28px 0 10px}
    h3{font-size:18px;margin:20px 0 8px}
    p{margin:10px 0}
    .lead{font-size:18px;color:#222}
    .btns{display:flex;flex-wrap:wrap;gap:10px;margin:18px 0 8px}
    .btn{appearance:none;border:1px solid var(--border);background:var(--accent);color:var(--accent-ink);padding:10px 14px;border-radius:999px;font-weight:600;text-decoration:none;display:inline-flex;gap:8px;align-items:center}
    .btn.secondary{background:transparent;color:var(--fg)}
    .btn.secondary:hover{background:#f4f7ff}
    .card{background:var(--card);border:1px solid var(--border);border-radius:var(--radius);padding:18px}
    ul{padding-left:22px}
    code,kbd,pre{font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace}
    pre{background:var(--code);color:var(--code-ink);padding:16px;border-radius:12px;overflow:auto;border:1px solid #00000020}
    .grid{display:grid;grid-template-columns: 1fr;gap:14px}
    .notice{background:#fff7cc;border:1px solid #ffe58f;padding:12px;border-radius:12px}
    .muted{color:var(--muted)}
    .toc{display:flex;gap:14px;flex-wrap:wrap}
    .toc a{display:inline-block;padding:6px 10px;border-radius:999px;background:#f4f4f5;border:1px solid var(--border);text-decoration:none;color:#222}
    footer{border-top:1px solid var(--border);margin-top:40px}
    .kbd{border:1px solid #d0d7de;border-bottom-width:2px;background:#fff;border-radius:6px;padding:0 6px;display:inline-block;font-size:12px}
    details{border:1px dashed var(--border);border-radius:12px;padding:12px}
    summary{cursor:pointer;font-weight:600}
  </style>
</head>
<body>
  <header>
    <div class="wrap">
      <div class="kicker">Free Plugin by DrGlenn</div>
      <h1>Force Reinstall / Update</h1>
      <p class="lead">A no‑nonsense utility that temporarily makes WordPress think <em>all</em> plugins have an available update so you can quickly reinstall them from <span class="kbd">Dashboard → Updates</span>. Deactivate when you’re done to clear the fake notices.</p>
      <div class="btns">
        <a class="btn" href="https://fixmyhackedwebsite.com/force-reinstall-update/forece-reinstall-update.zip">Download Force Reinstall (v1.1)</a>
        <a class="btn secondary" href="#features">Features</a>
        <a class="btn secondary" href="#installation">Installation</a>
      </div>
    </div>
  </header>

  <main>
    <div class="wrap">
      <nav class="toc" aria-label="Page">
        <a href="#overview">Overview</a>
        <a href="#why">Why You’ll Like It</a>
        <a href="#features">Features</a>
        <a href="#installation">Installation</a>
        <a href="#usage">Usage</a>
        <a href="#download">Download</a>
        <a href="#changelog">Changelog</a>
        <a href="#faq">FAQ</a>
        <a href="#disclaimers">Disclaimers</a>
      </nav>

      <section id="overview">
        <h2>Overview</h2>
        <p>When WordPress thinks a plugin has an update, the “reinstall” flow becomes a one‑click path. This plugin safely fabricates those update notices for all installed plugins (except itself), pointing the download package to the official WordPress.org repository. Deactivate it and the fake notices disappear immediately.</p>
        <p class="muted">Zero tracking • Tiny footprint • Safe fallbacks • Plays nice with your theme and other plugins.</p>
      </section>

      <section id="why">
        <h2>Why You’ll Like It</h2>
        <div class="grid">
          <div class="card">
            <h3>No bloat</h3>
            <p>Single‑purpose helper for fast cleanup/repairs—especially after a compromised site or messy update.</p>
          </div>
          <div class="card">
            <h3>Fast workflow</h3>
            <p>Reinstall everything from the native <em>Updates</em> screen—no manual zip juggling.</p>
          </div>
          <div class="card">
            <h3>Safe by design</h3>
            <p>Only touches the update transient and uses .org package URLs. Deactivation clears its changes.</p>
          </div>
        </div>
      </section>

      <section id="features">
        <h2>Features (v1.1)</h2>
        <ul>
          <li>Injects harmless “update available” entries for all installed plugins (skips itself).</li>
          <li>Packages point to official WordPress.org download URLs for each plugin slug.</li>
          <li>Respects your site version and sets <code>tested</code> accordingly.</li>
          <li>On deactivation, immediately deletes the <code>update_plugins</code> transient to remove fake notices.</li>
          <li>Displays a persistent admin warning while active so you remember to turn it off.</li>
        </ul>
        <h3>What It Touches</h3>
        <pre><code>add_filter('site_transient_update_plugins', 'force_all_plugin_updates');
register_deactivation_hook(__FILE__, 'force_reinstall_on_deactivate');</code></pre>
      </section>

      <section id="installation">
        <h2>Installation</h2>
        <ol>
          <li>Download the zip: <a href="https://fixmyhackedwebsite.com/force-reinstall-update/forece-reinstall-update.zip">forece-reinstall-update.zip</a></li>
          <li>WordPress admin → <strong>Plugins</strong> → <strong>Add New</strong> → <strong>Upload Plugin</strong> → choose the zip → <strong>Install Now</strong>.</li>
          <li>Click <strong>Activate</strong>.</li>
        </ol>
        <p class="muted">macOS tip: Hold <span class="kbd">Option</span> while clicking if your browser tries to open instead of download.</p>
      </section>

      <section id="usage">
        <h2>Usage</h2>
        <ul>
          <li>Go to <strong>Dashboard → Updates</strong>. All plugins will appear to have an update available.</li>
          <li>Reinstall the plugins you want. WordPress will fetch the latest package from WordPress.org.</li>
          <li>When finished, <strong>deactivate</strong> this helper to clear the fake notices.</li>
        </ul>
        <div class="notice" role="alert">
          <strong>Heads up:</strong> While active, the admin shows a warning banner. This is expected. Deactivate as soon as you’re done.
        </div>
      </section>

      <section id="download">
        <h2>Download</h2>
        <p>One‑file simplicity. Makes bulk reinstallation painless.</p>
        <p><a class="btn" href="https://fixmyhackedwebsite.com/force-reinstall-update/forece-reinstall-update.zip">Download Force Reinstall (v1.1)</a></p>
      </section>

      <section id="changelog">
        <h2>Changelog</h2>
        <h3>1.1</h3>
        <ul>
          <li>Added persistent admin notice while active.</li>
          <li>Copy and documentation improvements.</li>
        </ul>
        <h3>1.0</h3>
        <ul>
          <li>Initial release: injects update responses and clears on deactivate.</li>
        </ul>
      </section>

      <section id="faq">
        <h2>FAQ</h2>
        <h3>Does it modify plugin files?</h3>
        <p>No. It only edits the in‑memory update metadata that WordPress uses to decide whether to show an update badge.</p>
        <h3>Is it safe to leave active?</h3>
        <p>It won’t hurt anything, but you <em>should</em> deactivate it when finished to avoid confusion from perpetual update badges.</p>
        <h3>Can I see the code?</h3>
        <p>Absolutely—expand the source below.</p>
        <details>
          <summary>View PHP source (v1.1)</summary>
          <pre><code><?php
/**
 * Plugin Name:       Force Reinstall / Update
 * Description:       Trick WordPress into thinking all plugins have an update so you can reinstall from Updates. Deactivate to clear.
 * Version:           1.1
 * Author:            DrGlenn | Fixmyhackedwebsite.com
 */
if (!defined('ABSPATH')) { exit; }
function force_all_plugin_updates($transient){
  if(!is_object($transient) || !isset($transient->response)){ return $transient; }
  if(!function_exists('get_plugins')){ require_once ABSPATH.'wp-admin/includes/plugin.php'; }
  $all_plugins = get_plugins();
  if(empty($all_plugins)){ return $transient; }
  $this_plugin_basename = plugin_basename(__FILE__);
  foreach($all_plugins as $plugin_basename => $plugin_data){
    if($plugin_basename === $this_plugin_basename){ continue; }
    $slug = dirname($plugin_basename);
    if($slug === '.') { $slug = basename($plugin_basename, '.php'); }
    $o = new stdClass();
    $o->id = $plugin_basename;
    $o->slug = $slug;
    $o->plugin = $plugin_basename;
    $o->new_version = '999.999';
    $o->url = 'https://wordpress.org/plugins/' . $slug . '/';
    $o->package = 'https://downloads.wordpress.org/plugin/' . $slug . '.latest-stable.zip';
    $o->tested = get_bloginfo('version');
    $transient->response[$plugin_basename] = $o;
  }
  return $transient;
}
add_filter('site_transient_update_plugins', 'force_all_plugin_updates');
function force_reinstall_admin_notice(){
  echo '<div class="notice notice-warning is-dismissible"><p>' .
       __('The <strong>Force Reinstall / Update</strong> plugin is active. Deactivate after reinstalling.', 'force-reinstall') .
       '</p></div>';
}
add_action('admin_notices','force_reinstall_admin_notice');
function force_reinstall_on_deactivate(){ delete_site_transient('update_plugins'); }
register_deactivation_hook(__FILE__, 'force_reinstall_on_deactivate');
?></code></pre>
        </details>
      </section>

      <section id="disclaimers">
        <h2>Disclaimers</h2>
        <ul>
          <li><strong>No warranty:</strong> Provided “as is.” Test in your environment.</li>
          <li><strong>Confusion risk:</strong> While active, update badges are intentionally fake. Deactivate when finished.</li>
          <li><strong>Privacy:</strong> No external tracking. Uses only WordPress.org package URLs.</li>
          <li><strong>License:</strong> GPL‑2.0+. Modify and redistribute per that license.</li>
        </ul>
      </section>
    </div>
  </main>

  <footer>
    <div class="wrap">
      <p class="muted">©2025 DrGlenn. (https://FixMyHackedWebsite.com) No tracking. You are loved, and it shows!</p>
    </div>
  </footer>
</body>
</html>
